package examples.stateless.container;

import javax.ejb.EJB;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.http.HttpServlet;

import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import examples.stateless.interfaces.HelloWorld;

/**
 * Servlet Class
 *
 * @web.servlet              name="HelloWorld"
 *                           display-name="Name for HelloWorld"
 *                           description="Description for HelloWorld"
 * @web.servlet-mapping      url-pattern="/HelloWorld"
 * @web.servlet-init-param   name="A parameter"
 *                           value="A value"
 */
public class HelloWorldServlet extends HttpServlet {
	@EJB HelloWorld hwInjected;
	
	protected void doGet(HttpServletRequest req, HttpServletResponse resp)
		throws ServletException,
		IOException {

		doPost(req,resp);
	}

	protected void doPost(HttpServletRequest req, HttpServletResponse resp)
		throws ServletException,
		IOException {

		try {
			InitialContext ic = new InitialContext();
			HelloWorld hw = (HelloWorld)ic.lookup(HelloWorld.class.getName());
			
			PrintWriter pw = resp.getWriter();
			resp.setContentType("text/html");
			pw.println("<h4>Lookup output: "+hw.hi()+"</h4>");
			pw.println("<h4>Injection output: "+hwInjected.hi()+"</h4>");
		} 
		catch (NamingException e) {
			e.printStackTrace();
		}
	}
}
